/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileData;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileStats;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.WheelBase;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.DeployableRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.block.AutomobileAssemblerBlock;
import io.github.foundationgames.automobility.block.LaunchGelBlock;
import io.github.foundationgames.automobility.block.OffRoadBlock;
import io.github.foundationgames.automobility.block.SpecialAutomobileColliderBlock;
import io.github.foundationgames.automobility.controller.AutomobileController;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import io.github.foundationgames.automobility.entity.EntityWithContainer;
import io.github.foundationgames.automobility.entity.EntityWithInventory;
import io.github.foundationgames.automobility.entity.HitboxEntity;
import io.github.foundationgames.automobility.item.AutomobileInteractable;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.github.foundationgames.automobility.particle.AutomobilityParticles;
import io.github.foundationgames.automobility.platform.Platform;
import io.github.foundationgames.automobility.screen.AutomobileContainerLevelAccess;
import io.github.foundationgames.automobility.sound.AutomobilitySounds;
import io.github.foundationgames.automobility.util.AUtils;
import io.github.foundationgames.automobility.util.duck.CollisionArea;
import io.github.foundationgames.automobility.util.network.ClientPackets;
import io.github.foundationgames.automobility.util.network.CommonPackets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AutomobileEntity
extends Entity
implements RenderableAutomobile,
EntityWithInventory,
EntityWithContainer {
    public static Consumer<AutomobileEntity> engineSound = e -> {};
    public static Consumer<AutomobileEntity> skidSound = e -> {};
    public static Consumer<AutomobileEntity> hornSound = e -> {};
    private static final EntityDataAccessor<Float> REAR_ATTACHMENT_YAW = SynchedEntityData.defineId(AutomobileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> REAR_ATTACHMENT_ANIMATION = SynchedEntityData.defineId(AutomobileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> FRONT_ATTACHMENT_ANIMATION = SynchedEntityData.defineId(AutomobileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Holder<AutomobileFrame>> FRAME_TYPE = SynchedEntityData.defineId(AutomobileEntity.class, AutomobileFrame.SERIALIZER);
    private static final EntityDataAccessor<Holder<AutomobileWheel>> WHEEL_TYPE = SynchedEntityData.defineId(AutomobileEntity.class, AutomobileWheel.SERIALIZER);
    private static final EntityDataAccessor<Holder<AutomobileEngine>> ENGINE_TYPE = SynchedEntityData.defineId(AutomobileEntity.class, AutomobileEngine.SERIALIZER);
    private RearAttachment rearAttachment;
    private FrontAttachment frontAttachment;
    private final AutomobileStats stats = new AutomobileStats();
    public static final int SMALL_TURBO_TIME = 35;
    public static final int MEDIUM_TURBO_TIME = 70;
    public static final int LARGE_TURBO_TIME = 115;
    public static final float TERMINAL_VELOCITY = -1.2f;
    public final Input input = new Input();
    private boolean prevHoldDrift;
    private long clientTime;
    private double trackedX;
    private double trackedY;
    private double trackedZ;
    private float trackedYaw;
    private int lerpTicks;
    private static final int CLIENT_SYNC_INTERVAL = 4;
    private int clientSyncTicks;
    public final List<HitboxEntity> hitboxes;
    private EntityDimensions size;
    private AABB cullingBox;
    private boolean dirty;
    private float engineSpeed;
    private float boostSpeed;
    private float speedDirection;
    private float lastBoostSpeed;
    private float lossySyncedEffectiveSpeed;
    private float lastSyncedBoostSpeed;
    private float lossySyncedBoostSpeed;
    private float lastSyncedWheelAngle;
    private float lossySyncedWheelAngle;
    private int dataLerpTicks;
    private int boostTimer;
    private float boostPower;
    private int jumpCooldown;
    private float hSpeed;
    private float vSpeed;
    private Vec3 addedVelocity;
    private float steering;
    private float lastSteering;
    private float angularSpeed;
    private float wheelAngle;
    private float lastWheelAngle;
    private final Displacement displacement;
    private boolean drifting;
    private boolean burningOut;
    private int driftDir;
    private int turboCharge;
    private boolean honking;
    private boolean automobileOnGround;
    private boolean wasOnGround;
    private boolean isFloorDirectlyBelow;
    private boolean touchingWall;
    private int hadVehicleCollision;
    private Vec3 lastVelocity;
    private Vec3 lastMeasuredPos;
    private Vec3 prevTailPos;
    private float prevYawForRotate;
    private int slopeStickingTimer;
    private float grip;
    private int suspensionBounceTimer;
    private int lastSusBounceTimer;
    private final Deque<Double> prevYDisplacements;
    private boolean offRoad;
    private Vector3f debrisColor;
    private int fallTicks;
    private int despawnTime;
    private int despawnCountdown;
    private boolean decorative;
    private boolean wasEngineRunning;
    private float standStillTime;

    public void writeSyncStateData(FriendlyByteBuf buf) {
        buf.writeInt(this.boostTimer);
        buf.writeFloat(this.steering);
        buf.writeFloat(this.wheelAngle);
        buf.writeInt(this.turboCharge);
        buf.writeFloat(this.engineSpeed);
        buf.writeFloat(this.boostSpeed);
        this.input.writePacket(buf);
        buf.writeBoolean(this.drifting);
        buf.writeBoolean(this.burningOut);
    }

    public void readSyncStateData(FriendlyByteBuf buf) {
        this.boostTimer = buf.readInt();
        this.steering = buf.readFloat();
        this.wheelAngle = buf.readFloat();
        this.turboCharge = buf.readInt();
        this.engineSpeed = buf.readFloat();
        this.boostSpeed = buf.readFloat();
        this.input.readPacket(buf);
        this.setDrifting(buf.readBoolean());
        this.setBurningOut(buf.readBoolean());
        this.dataLerpTicks = 4;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        RegistryAccess reg = this.registryAccess();
        this.setComponents((Holder<AutomobileFrame>)reg.registryOrThrow(AutomobileFrame.REGISTRY).getHolder(ResourceLocation.tryParse((String)nbt.getString("frame"))).map(r -> r).orElseGet(() -> Holder.direct((Object)AutomobileFrame.EMPTY)), (Holder<AutomobileWheel>)reg.registryOrThrow(AutomobileWheel.REGISTRY).getHolder(ResourceLocation.tryParse((String)nbt.getString("wheels"))).map(r -> r).orElseGet(() -> Holder.direct((Object)AutomobileWheel.EMPTY)), (Holder<AutomobileEngine>)reg.registryOrThrow(AutomobileEngine.REGISTRY).getHolder(ResourceLocation.tryParse((String)nbt.getString("engine"))).map(r -> r).orElseGet(() -> Holder.direct((Object)AutomobileEngine.EMPTY)));
        CompoundTag rAtt = nbt.getCompound("rearAttachment");
        this.setRearAttachment(RearAttachment.fromNbt(rAtt));
        this.rearAttachment.readNbt(rAtt, (HolderLookup.Provider)this.level().registryAccess());
        CompoundTag fAtt = nbt.getCompound("frontAttachment");
        this.setFrontAttachment(FrontAttachment.fromNbt(fAtt));
        this.frontAttachment.readNbt(fAtt, (HolderLookup.Provider)this.level().registryAccess());
        this.engineSpeed = nbt.getFloat("engineSpeed");
        this.boostSpeed = nbt.getFloat("boostSpeed");
        this.boostTimer = nbt.getInt("boostTimer");
        this.boostPower = nbt.getFloat("boostPower");
        this.speedDirection = nbt.getFloat("speedDirection");
        this.vSpeed = nbt.getFloat("verticalSpeed");
        this.hSpeed = nbt.getFloat("horizontalSpeed");
        this.addedVelocity = AUtils.v3dFromNbt(nbt.getCompound("addedVelocity"));
        this.lastVelocity = AUtils.v3dFromNbt(nbt.getCompound("lastVelocity"));
        this.angularSpeed = nbt.getFloat("angularSpeed");
        this.steering = nbt.getFloat("steering");
        this.wheelAngle = nbt.getFloat("wheelAngle");
        this.drifting = nbt.getBoolean("drifting");
        this.driftDir = nbt.getInt("driftDir");
        this.burningOut = nbt.getBoolean("burningOut");
        this.honking = nbt.getBoolean("honking");
        this.turboCharge = nbt.getInt("turboCharge");
        this.input.accelerating = nbt.getBoolean("accelerating");
        this.input.braking = nbt.getBoolean("braking");
        this.input.steering = nbt.getFloat("steeringInput");
        this.input.holdingDrift = nbt.getBoolean("holdingDrift");
        this.input.holdingHorn = nbt.getBoolean("holdingHorn");
        this.fallTicks = nbt.getInt("fallTicks");
        this.despawnTime = nbt.getInt("despawnTime");
        this.despawnCountdown = nbt.getInt("despawnCountdown");
        this.decorative = nbt.getBoolean("decorative");
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        ((Holder)this.entityData.get(FRAME_TYPE)).unwrapKey().ifPresent(k -> nbt.putString("frame", k.location().toString()));
        ((Holder)this.entityData.get(WHEEL_TYPE)).unwrapKey().ifPresent(k -> nbt.putString("wheels", k.location().toString()));
        ((Holder)this.entityData.get(ENGINE_TYPE)).unwrapKey().ifPresent(k -> nbt.putString("engine", k.location().toString()));
        nbt.put("rearAttachment", (Tag)this.rearAttachment.toNbt());
        nbt.put("frontAttachment", (Tag)this.frontAttachment.toNbt());
        nbt.putFloat("engineSpeed", this.engineSpeed);
        nbt.putFloat("boostSpeed", this.boostSpeed);
        nbt.putInt("boostTimer", this.boostTimer);
        nbt.putFloat("boostPower", this.boostPower);
        nbt.putFloat("speedDirection", this.speedDirection);
        nbt.putFloat("verticalSpeed", this.vSpeed);
        nbt.putFloat("horizontalSpeed", this.hSpeed);
        nbt.put("addedVelocity", (Tag)AUtils.v3dToNbt(this.addedVelocity));
        nbt.put("lastVelocity", (Tag)AUtils.v3dToNbt(this.lastVelocity));
        nbt.putFloat("angularSpeed", this.angularSpeed);
        nbt.putFloat("steering", this.steering);
        nbt.putFloat("wheelAngle", this.wheelAngle);
        nbt.putBoolean("drifting", this.drifting);
        nbt.putInt("driftDir", this.driftDir);
        nbt.putBoolean("burningOut", this.burningOut);
        nbt.putBoolean("honking", this.honking);
        nbt.putInt("turboCharge", this.turboCharge);
        nbt.putBoolean("accelerating", this.input.accelerating);
        nbt.putBoolean("braking", this.input.braking);
        nbt.putFloat("steeringInput", this.input.steering);
        nbt.putBoolean("holdingDrift", this.input.holdingDrift);
        nbt.putBoolean("holdingHorn", this.input.holdingHorn);
        nbt.putInt("fallTicks", this.fallTicks);
        nbt.putInt("despawnTime", this.despawnTime);
        nbt.putInt("despawnCountdown", this.despawnCountdown);
        nbt.putBoolean("decorative", this.decorative);
    }

    public AutomobileEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.prevHoldDrift = this.input.holdingDrift;
        this.clientSyncTicks = 4;
        this.hitboxes = new ArrayList<HitboxEntity>();
        this.cullingBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.dirty = false;
        this.engineSpeed = 0.0f;
        this.boostSpeed = 0.0f;
        this.speedDirection = 0.0f;
        this.lastBoostSpeed = this.boostSpeed;
        this.lossySyncedEffectiveSpeed = 0.0f;
        this.lastSyncedBoostSpeed = 0.0f;
        this.lossySyncedBoostSpeed = 0.0f;
        this.lastSyncedWheelAngle = 0.0f;
        this.lossySyncedWheelAngle = 0.0f;
        this.boostTimer = 0;
        this.boostPower = 0.0f;
        this.jumpCooldown = 0;
        this.hSpeed = 0.0f;
        this.vSpeed = 0.0f;
        this.addedVelocity = this.getDeltaMovement();
        this.lastSteering = this.steering = 0.0f;
        this.angularSpeed = 0.0f;
        this.wheelAngle = 0.0f;
        this.lastWheelAngle = 0.0f;
        this.displacement = new Displacement();
        this.drifting = false;
        this.burningOut = false;
        this.driftDir = 0;
        this.turboCharge = 0;
        this.honking = false;
        this.wasOnGround = this.automobileOnGround = true;
        this.isFloorDirectlyBelow = true;
        this.touchingWall = false;
        this.hadVehicleCollision = 0;
        this.lastVelocity = Vec3.ZERO;
        this.lastMeasuredPos = Vec3.ZERO;
        this.prevTailPos = null;
        this.prevYawForRotate = 0.0f;
        this.slopeStickingTimer = 0;
        this.grip = 1.0f;
        this.lastSusBounceTimer = this.suspensionBounceTimer = 0;
        this.prevYDisplacements = new ArrayDeque<Double>();
        this.offRoad = false;
        this.debrisColor = new Vector3f();
        this.fallTicks = 0;
        this.despawnTime = -1;
        this.despawnCountdown = 0;
        this.decorative = false;
        this.wasEngineRunning = false;
        this.standStillTime = -1.3f;
        this.setRearAttachment(RearAttachmentType.REGISTRY.getOrDefault(null));
        this.setFrontAttachment(FrontAttachmentType.REGISTRY.getOrDefault(null));
        this.size = type.getDimensions();
    }

    public AutomobileEntity(Level world) {
        this(AutomobilityEntities.AUTOMOBILE.require(), world);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        if (this.level().isClientSide()) {
            ClientPackets.requestSyncAutomobileComponentsPacket(this);
        }
    }

    private void controllerAction(Consumer<AutomobileController> action) {
        if (this.level().isClientSide() && this.getControllingPassenger() == Minecraft.getInstance().player) {
            action.accept(Platform.get().controller());
        }
    }

    @Override
    public AutomobileFrame getFrame() {
        return (AutomobileFrame)((Holder)this.entityData.get(FRAME_TYPE)).value();
    }

    @Override
    public AutomobileWheel getWheels() {
        return (AutomobileWheel)((Holder)this.entityData.get(WHEEL_TYPE)).value();
    }

    @Override
    public AutomobileEngine getEngine() {
        return (AutomobileEngine)((Holder)this.entityData.get(ENGINE_TYPE)).value();
    }

    @Override
    @Nullable
    public RearAttachment getRearAttachment() {
        return this.rearAttachment;
    }

    @Override
    @Nullable
    public FrontAttachment getFrontAttachment() {
        return this.frontAttachment;
    }

    @Override
    public float getSteering(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.lastSteering, (float)this.steering);
    }

    @Override
    public float getWheelAngle(float tickDelta) {
        if (this.isControlledByLocalInstance()) {
            return Mth.lerp((float)tickDelta, (float)this.lastWheelAngle, (float)this.wheelAngle);
        }
        return Mth.lerp((float)tickDelta, (float)this.lastSyncedWheelAngle, (float)this.lossySyncedWheelAngle);
    }

    public float getBoostSpeed(float tickDelta) {
        if (this.isControlledByLocalInstance()) {
            return Mth.lerp((float)tickDelta, (float)this.lastBoostSpeed, (float)this.boostSpeed);
        }
        return Mth.lerp((float)tickDelta, (float)this.lastSyncedBoostSpeed, (float)this.lossySyncedBoostSpeed);
    }

    @Override
    public float getSuspensionBounce(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.lastSusBounceTimer, (float)this.suspensionBounceTimer);
    }

    @Override
    public boolean engineRunning() {
        FrontAttachment fAtt;
        boolean running;
        boolean bl = running = this.boostTimer > 0 || this.isVehicle();
        if (!running && (fAtt = this.getFrontAttachment()) != null) {
            running = fAtt.isProvidingAlternativeInputs(this, this.getFirstPassenger());
        }
        return running;
    }

    @Override
    public int getTurboCharge() {
        return this.turboCharge;
    }

    @Override
    public long getTime() {
        return this.clientTime;
    }

    public float getHSpeed() {
        return this.hSpeed;
    }

    public float getVSpeed() {
        return this.vSpeed;
    }

    @Override
    public int getBoostTimer() {
        return this.boostTimer;
    }

    public float calculateEffectiveSpeed() {
        Player player;
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isLocalPlayer()) {
            return (float)Math.max(this.addedVelocity.length(), (double)Math.abs(this.hSpeed));
        }
        return (float)Math.max(this.addedVelocity.length(), (double)Math.abs(this.engineSpeed + this.boostSpeed));
    }

    public float getEffectiveSpeed() {
        if (this.isControlledByLocalInstance()) {
            return this.calculateEffectiveSpeed();
        }
        return this.lossySyncedEffectiveSpeed;
    }

    @Override
    public boolean automobileOnGround() {
        return this.automobileOnGround;
    }

    @Override
    public boolean debris() {
        return this.offRoad && this.hSpeed != 0.0f;
    }

    @Override
    public Vector3f debrisColor() {
        return this.debrisColor;
    }

    public boolean burningOut() {
        return this.burningOut;
    }

    public boolean honking() {
        return this.honking;
    }

    private void setDrifting(boolean drifting) {
        if (this.level().isClientSide() && !this.drifting && drifting) {
            skidSound.accept(this);
        }
        this.drifting = drifting;
    }

    private void setBurningOut(boolean burningOut) {
        if (this.level().isClientSide() && !this.drifting && !this.burningOut && burningOut) {
            skidSound.accept(this);
        }
        if (this.burningOut != burningOut || this.turboCharge >= 115 != burningOut) {
            this.controllerAction(c -> c.updateMaxChargeRumbleState(burningOut));
        }
        this.burningOut = burningOut;
    }

    private void setHonking(boolean honking) {
        if (this.level().isClientSide() && !this.honking && honking) {
            hornSound.accept(this);
        }
        this.honking = honking;
    }

    public boolean isDrifting() {
        return this.drifting;
    }

    public <T extends RearAttachment> void setRearAttachment(RearAttachmentType<T> rearAttachment) {
        if (rearAttachment == null) {
            return;
        }
        if (this.rearAttachment == null || this.rearAttachment.type != rearAttachment) {
            if (this.rearAttachment != null) {
                this.rearAttachment.onRemoved();
            }
            this.rearAttachment = (RearAttachment)rearAttachment.constructor().apply(rearAttachment, this);
            this.rearAttachment.setYaw(this.getYRot());
            if (!this.level().isClientSide() && !this.rearAttachment.isRideable() && this.getPassengers().size() > 1) {
                ((Entity)this.getPassengers().get(1)).stopRiding();
            }
            this.syncAttachments();
        }
    }

    public <T extends FrontAttachment> void setFrontAttachment(FrontAttachmentType<T> frontAttachment) {
        if (frontAttachment == null) {
            return;
        }
        if (this.frontAttachment == null || this.frontAttachment.type != frontAttachment) {
            if (this.frontAttachment != null) {
                this.frontAttachment.onRemoved();
            }
            this.frontAttachment = (FrontAttachment)frontAttachment.constructor().apply(frontAttachment, this);
            this.syncAttachments();
        }
    }

    public void setComponents(Holder<AutomobileFrame> frame, Holder<AutomobileWheel> wheel, Holder<AutomobileEngine> engine) {
        this.entityData.set(FRAME_TYPE, frame);
        this.entityData.set(WHEEL_TYPE, wheel);
        this.entityData.set(ENGINE_TYPE, engine);
        this.stats.from(this.getFrame(), this.getWheels(), this.getEngine());
        this.size = this.getFrame().makeBounds();
        this.displacement.applyWheelbase(this.getFrame().model().wheelBase());
        this.refreshDimensions();
    }

    public void verifyHitboxesFor(AutomobileFrame frame) {
        this.hitboxes.removeIf(Entity::isRemoved);
        if (this.level().isClientSide()) {
            return;
        }
        List<AutomobileFrame.Hitbox> boxes = frame.hitboxes();
        if (boxes.isEmpty()) {
            boxes = List.of(AutomobileFrame.Hitbox.DEFAULT);
        }
        if (this.hitboxes.size() != boxes.size()) {
            this.hitboxes.forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
            this.hitboxes.clear();
            for (AutomobileFrame.Hitbox box : boxes) {
                HitboxEntity boxEntity = new HitboxEntity(this.level(), this, box);
                boxEntity.setPos(this.position());
                this.hitboxes.add(boxEntity);
                this.level().addFreshEntity((Entity)boxEntity);
            }
        }
    }

    public float maxUpStep() {
        return this.getWheels().size();
    }

    public void forPlayersTrackingMe(boolean ignoreDriver, Consumer<ServerPlayer> action) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            ChunkPos cPos = new ChunkPos(this.blockPosition());
            for (ServerPlayer p : sl.getPlayers(s -> s.getChunkTrackingView().contains(cPos))) {
                if (ignoreDriver && this.isDriving((Entity)p)) continue;
                action.accept(p);
            }
        }
    }

    public Vec3 getTailPos() {
        return this.position().add(new Vec3(0.0, 0.0, (double)this.getFrame().model().rearAttachmentPos() * 0.0625).yRot((float)Math.toRadians(180.0f - this.getYRot())));
    }

    public Vec3 getHeadPos() {
        return this.position().add(new Vec3(0.0, 0.0, (double)this.getFrame().model().frontAttachmentPos() * 0.0625).yRot((float)Math.toRadians(-this.getYRot())));
    }

    public void updateCullingBox() {
        this.cullingBox = super.getBoundingBoxForCulling();
        for (HitboxEntity hitbox : this.hitboxes) {
            this.cullingBox = this.cullingBox.minmax(hitbox.getBoundingBox());
        }
    }

    public AABB getBoundingBoxForCulling() {
        return this.cullingBox;
    }

    public boolean hasSpaceForPassengers() {
        int maxPassengers;
        AutomobileFrame frame = this.getFrame();
        int n = maxPassengers = this.rearAttachment.isRideable() ? 2 : 1;
        if (frame != null) {
            maxPassengers += frame.model().passengerSeats().size();
        }
        return this.getPassengers().size() < maxPassengers;
    }

    public boolean isDriving(@Nullable Entity entity) {
        if (entity != null && entity == this.getFirstPassenger()) {
            FrontAttachment fAtt = this.getFrontAttachment();
            if (fAtt != null) {
                return fAtt.canDrive(entity);
            }
            return true;
        }
        return false;
    }

    public void setSpeed(float horizontal, float vertical) {
        this.hSpeed = horizontal;
        this.vSpeed = vertical;
    }

    public void clientOnAboutToDismount() {
        ClientPackets.sendServerboundAutomobileSyncPacket(this);
    }

    private void lerpAutomobileData() {
        this.lastSyncedWheelAngle = this.lossySyncedWheelAngle;
        this.lastSyncedBoostSpeed = this.lossySyncedBoostSpeed;
        if (this.dataLerpTicks <= 0) {
            return;
        }
        this.lossySyncedEffectiveSpeed += (this.calculateEffectiveSpeed() - this.lossySyncedEffectiveSpeed) / (float)this.dataLerpTicks;
        this.lossySyncedBoostSpeed += (this.boostSpeed - this.lossySyncedBoostSpeed) / (float)this.dataLerpTicks;
        this.lossySyncedWheelAngle += (this.wheelAngle - this.lossySyncedWheelAngle) / (float)this.dataLerpTicks;
        --this.dataLerpTicks;
    }

    public void tick() {
        boolean fAttDriving;
        boolean first = this.firstTick;
        if (this.lastWheelAngle != this.wheelAngle) {
            this.markDirty();
        }
        this.lastWheelAngle = this.wheelAngle;
        if (!this.wasEngineRunning && this.engineRunning() && this.level().isClientSide()) {
            engineSound.accept(this);
        }
        this.wasEngineRunning = this.engineRunning();
        FrontAttachment fAtt = this.getFrontAttachment();
        boolean bl = fAttDriving = fAtt != null && fAtt.isProvidingAlternativeInputs(this, this.getFirstPassenger());
        if (!(this.isVehicle() || this.isDriving(this.getFirstPassenger()) || fAttDriving)) {
            this.input.clearInputs();
        }
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        super.tick();
        if (!((RearAttachmentType)this.rearAttachment.type).isEmpty()) {
            this.rearAttachment.tick();
        }
        if (!((FrontAttachmentType)this.frontAttachment.type).isEmpty()) {
            this.frontAttachment.tick();
        }
        Vec3 prevPos = this.position();
        this.prevYawForRotate = this.getYRot();
        this.setHonking(this.input.holdingHorn);
        this.lerpAutomobileData();
        this.positionTrackingTick();
        this.collisionStateTick();
        this.steeringTick();
        this.driftingTick();
        this.burnoutTick();
        this.receiveVehicleCollisions();
        this.movementTick();
        if (this.isControlledByLocalInstance()) {
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        this.postMovementTick();
        this.verifyHitboxesFor(this.getFrame());
        if (!this.level().isClientSide()) {
            Vec3 prevTailPos = this.prevTailPos != null ? this.prevTailPos : this.getTailPos();
            Vec3 tailPos = this.getTailPos();
            this.rearAttachment.pull(prevTailPos.subtract(tailPos));
            this.prevTailPos = tailPos;
            if (this.dirty) {
                this.syncData();
                this.dirty = false;
            }
            if (this.hasSpaceForPassengers() && !this.decorative) {
                List touchingEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.2, 0.0, 0.2), EntitySelector.pushableBy((Entity)this));
                for (Entity entity : touchingEntities) {
                    if (entity.hasPassenger((Entity)this) || entity.isPassenger() || !(entity.getBbWidth() <= this.getBbWidth()) || !(entity instanceof Mob) || entity instanceof WaterAnimal) continue;
                    entity.startRiding((Entity)this);
                }
            }
            if (fAttDriving) {
                boolean wasHoldingHorn = this.input.holdingHorn;
                fAtt.provideAlternativeInputs(this, this.input, this.getFirstPassenger());
                this.despawnCountdown = 0;
                if (wasHoldingHorn != this.input.holdingHorn) {
                    this.syncData();
                }
            } else if (this.isVehicle()) {
                this.despawnCountdown = 0;
            } else if (this.despawnTime > 0) {
                ++this.despawnCountdown;
                if (this.despawnCountdown >= this.despawnTime) {
                    this.destroyAutomobile(false, Entity.RemovalReason.DISCARDED);
                }
            }
        } else {
            ++this.clientTime;
            this.lastSusBounceTimer = this.suspensionBounceTimer;
            if (this.suspensionBounceTimer > 0) {
                --this.suspensionBounceTimer;
            }
            this.standStillTime = (double)Math.abs(this.hSpeed) < 0.05 && !this.burningOut && this.getControllingPassenger() instanceof Player ? AUtils.shift(this.standStillTime, 0.05f, 1.0f) : AUtils.shift(this.standStillTime, 0.15f, -1.3f);
            --this.clientSyncTicks;
            if (this.clientSyncTicks <= 0) {
                this.clientSyncTicks = 4;
                ClientPackets.sendServerboundAutomobileSyncPacket(this);
            }
            this.updateCullingBox();
        }
        this.displacementTick(first || this.position().subtract(prevPos).length() > 0.0 || this.getYRot() != this.yRotO);
    }

    public void positionTrackingTick() {
        if (this.isControlledByLocalInstance()) {
            this.lerpTicks = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        } else if (this.lerpTicks > 0) {
            this.setPos(this.getX() + (this.trackedX - this.getX()) / (double)this.lerpTicks, this.getY() + (this.trackedY - this.getY()) / (double)this.lerpTicks, this.getZ() + (this.trackedZ - this.getZ()) / (double)this.lerpTicks);
            this.setYRot(this.getYRot() + Mth.wrapDegrees((float)(this.trackedYaw - this.getYRot())) / (float)this.lerpTicks);
            --this.lerpTicks;
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void syncData() {
        this.forPlayersTrackingMe(true, player -> CommonPackets.sendClientboundAutomobileSyncPacket(this, player));
    }

    private void syncAttachments() {
        this.forPlayersTrackingMe(false, player -> CommonPackets.sendSyncAutomobileAttachmentsPacket(this, player));
    }

    public ItemStack asPrefabItem() {
        return new AutomobileData(Optional.empty(), ((Holder)this.entityData.get(FRAME_TYPE)).unwrapKey().orElse(AutomobileFrame.EMPTY_KEY), ((Holder)this.entityData.get(WHEEL_TYPE)).unwrapKey().orElse(AutomobileWheel.EMPTY_KEY), ((Holder)this.entityData.get(ENGINE_TYPE)).unwrapKey().orElse(AutomobileEngine.EMPTY_KEY)).asStack();
    }

    public void updateEngineSpeed(float speed) {
        if (!this.isControlledByLocalInstance()) {
            return;
        }
        this.engineSpeed = speed;
    }

    public void updateBoostSpeed(float speed) {
        if (!this.isControlledByLocalInstance()) {
            return;
        }
        this.boostSpeed = speed;
    }

    public void movementTick() {
        Block block;
        boolean wasOffRoad;
        this.lastBoostSpeed = this.boostSpeed;
        if (this.boostTimer > 0) {
            --this.boostTimer;
            this.updateBoostSpeed(Math.min(this.boostPower, this.boostSpeed + 0.09f));
            if (this.engineSpeed < this.stats.getComfortableSpeed()) {
                this.engineSpeed += 0.012f;
            }
            this.markDirty();
            if (this.boostTimer == 0) {
                this.controllerAction(c -> c.updateBoostingRumbleState(false, 0.0f));
            }
        } else {
            this.updateBoostSpeed(AUtils.zero(this.boostSpeed, 0.09f));
        }
        BlockPos blockBelow = new BlockPos((int)this.getX(), (int)(this.getY() - 0.05), (int)this.getZ());
        this.grip = 1.0f - Mth.clamp((float)((this.level().getBlockState(blockBelow).getBlock().getFriction() - 0.6f) / 0.4f), (float)0.0f, (float)1.0f) * (1.0f - this.stats.getGrip() * 0.8f);
        this.grip *= this.grip;
        if (this.automobileOnGround && this.jumpCooldown <= 0 && this.level().getBlockState(this.blockPosition()).getBlock() instanceof LaunchGelBlock) {
            this.setSpeed(Math.max(this.getHSpeed(), 0.1f), Math.max(this.getVSpeed(), 0.9f));
            this.jumpCooldown = 5;
            this.automobileOnGround = false;
        }
        this.lastMeasuredPos = this.position();
        Vec3 cumulative = this.addedVelocity;
        cumulative = cumulative.add(0.0, (double)(this.vSpeed * (this.isUnderWater() ? 0.15f : 1.0f)), 0.0);
        this.speedDirection = this.getYRot() - (this.drifting ? Math.min((float)(this.turboCharge * 6), 43.0f + -this.steering * 12.0f) * (float)this.driftDir : -this.steering * 12.0f);
        if (this.input.accelerating) {
            float speed = Math.max(this.engineSpeed, 0.0f);
            double acc = this.drifting && AUtils.haveSameSign(this.steering, this.driftDir) || !this.drifting && this.steering != 0.0f && (double)this.hSpeed > 0.5 ? (this.hSpeed < this.stats.getComfortableSpeed() ? 0.001 : 0.0) : (double)this.calculateAcceleration(speed, this.stats) * (this.drifting ? 0.86 : 1.0) * (double)(this.engineSpeed > this.stats.getComfortableSpeed() ? 0.25f : 1.0f) * (double)this.grip;
            this.updateEngineSpeed(this.engineSpeed + (float)acc);
        }
        if (this.input.braking) {
            this.updateEngineSpeed(Math.max(this.engineSpeed - 0.15f, -0.25f));
        }
        if (!this.input.accelerating && !this.input.braking) {
            this.updateEngineSpeed(AUtils.zero(this.engineSpeed, 0.025f));
        }
        if (!this.drifting && this.steering != 0.0f && (double)this.hSpeed > 0.8) {
            this.updateEngineSpeed(this.engineSpeed - this.engineSpeed * 4.2E-4f);
        }
        if (this.burningOut()) {
            this.updateEngineSpeed(this.engineSpeed - this.engineSpeed * 0.5f);
        }
        BlockPos below = new BlockPos((int)this.getX(), (int)(this.getY() - 0.51), (int)this.getZ());
        BlockState state = this.level().getBlockState(below);
        this.slopeStickingTimer = state.is(Automobility.STICKY_SLOPES) ? 1 : Math.max(0, this.slopeStickingTimer--);
        boolean bl = wasOffRoad = this.offRoad && (double)this.hSpeed > 0.01;
        if (this.boostSpeed < 0.4f && (block = this.level().getBlockState(this.blockPosition()).getBlock()) instanceof OffRoadBlock) {
            OffRoadBlock block2 = (OffRoadBlock)block;
            int layers = (Integer)this.level().getBlockState(this.blockPosition()).getValue((Property)OffRoadBlock.LAYERS);
            float cap = this.stats.getComfortableSpeed() * (1.0f - (float)layers / 3.5f);
            this.updateEngineSpeed(Math.min(cap, this.engineSpeed));
            this.debrisColor = block2.color;
            this.offRoad = true;
        } else {
            this.offRoad = false;
        }
        if ((this.offRoad && (double)this.hSpeed > 0.01) != wasOffRoad) {
            this.controllerAction(c -> c.updateOffRoadRumbleState(this.offRoad));
        }
        if (!this.burningOut()) {
            this.hSpeed = this.engineSpeed + this.boostSpeed;
        }
        double lowestPrevYDisp = 0.0;
        for (double d : this.prevYDisplacements) {
            lowestPrevYDisp = Math.min(d, lowestPrevYDisp);
        }
        if (this.slopeStickingTimer > 0 && this.automobileOnGround && lowestPrevYDisp <= 0.0) {
            double cumulHSpeed = Math.sqrt(cumulative.x * cumulative.x + cumulative.z * cumulative.z);
            cumulative = cumulative.add(0.0, -(0.25 + cumulHSpeed), 0.0);
        }
        float angle = (float)Math.toRadians(-this.speedDirection);
        if (this.burningOut()) {
            if ((double)Math.abs(this.hSpeed) > 0.02) {
                this.addedVelocity = new Vec3(Math.sin(angle) * (double)this.hSpeed, 0.0, Math.cos(angle) * (double)this.hSpeed);
                this.hSpeed = 0.0f;
                cumulative = cumulative.add(this.addedVelocity);
            }
        } else {
            cumulative = cumulative.add(Math.sin(angle) * (double)this.hSpeed, 0.0, Math.cos(angle) * (double)this.hSpeed);
        }
        if ((cumulative = cumulative.scale((double)this.grip).add(this.lastVelocity.scale((double)(1.0f - this.grip)))).length() < 0.001) {
            cumulative = Vec3.ZERO;
        }
        float wheelCircumference = (float)((double)(2.0f * (this.getWheels().model().radius() / 16.0f)) * Math.PI);
        if (this.hSpeed > 0.0f) {
            this.markDirty();
        }
        this.wheelAngle += 300.0f * (this.hSpeed / wheelCircumference) + (this.hSpeed > 0.0f ? (1.0f - this.grip) * 15.0f : 0.0f);
        if (this.isControlledByLocalInstance()) {
            this.setDeltaMovement(cumulative);
        }
        this.markHurt();
        this.hasImpulse = true;
        this.lastVelocity = cumulative;
        if ((double)Math.abs(this.hSpeed) > 0.2) {
            this.runOverEntities(cumulative);
        }
    }

    public void runOverEntities(Vec3 velocity) {
        HashSet<LivingEntity> entitiesToHit = new HashSet<LivingEntity>();
        Vec3 velAdd = velocity.add(0.0, 0.1, 0.0).scale(3.0);
        for (HitboxEntity box : this.hitboxes) {
            AABB bbox = box.getBoundingBox().move(velocity.scale(0.5));
            for (Entity entity2 : this.level().getEntities(EntityTypeTest.forClass(Entity.class), bbox, entity -> entity != this && entity.getVehicle() != this)) {
                if (entity2.isInvulnerable() || !(entity2 instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity2;
                if (entity2.getVehicle() == this) continue;
                entitiesToHit.add(living);
            }
        }
        entitiesToHit.forEach(e -> {
            AutomobilityEntities.automobileDamageSource(this.level()).ifPresent(dmg -> e.hurt(dmg, this.hSpeed * 10.0f));
            e.push(velAdd.x, velAdd.y, velAdd.z);
        });
    }

    public void receiveVehicleCollisions() {
        HashMap<AutomobileEntity, IncomingCollision> collisions = new HashMap<AutomobileEntity, IncomingCollision>();
        for (HitboxEntity box : this.hitboxes) {
            AABB bbox = box.getBoundingBox().inflate(0.15);
            for (HitboxEntity hitbox : this.level().getEntities(EntityTypeTest.forClass(HitboxEntity.class), bbox, h -> h.automobile() != this)) {
                AutomobileEntity auto = hitbox.automobile();
                AABB intersect = hitbox.getBoundingBox().inflate(0.15).intersect(bbox);
                Vec3 collDepth = new Vec3(intersect.getXsize(), 0.0, intersect.getZsize());
                if (auto == null || collisions.containsKey(auto) && ((IncomingCollision)collisions.get(auto)).depth().lengthSqr() > collDepth.lengthSqr()) continue;
                Vec3 momentum = auto.getMeasuredMovement();
                Vec3 origin = intersect.getCenter();
                collisions.put(auto, new IncomingCollision(collDepth, momentum, origin, auto.getFrame().weight()));
            }
        }
        this.hadVehicleCollision = Math.max(0, this.hadVehicleCollision - 1);
        for (IncomingCollision col : collisions.values()) {
            Vec3 meToCollision = col.origin().subtract(this.position()).multiply(1.0, 0.0, 1.0);
            double hitScale = this.hadVehicleCollision <= 0 ? 0.15 : 0.07;
            this.addedVelocity = this.addedVelocity.add(meToCollision.reverse().normalize().scale((hitScale *= (double)(1.0f + col.inertia() / this.getFrame().weight()) * 0.5) * (1.0 + 0.1 * Math.sqrt(col.velocity().length())) * col.depth().lengthSqr()).add(0.0, col.velocity().length() * 0.2, 0.0));
            if (this.hadVehicleCollision > 0) continue;
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), AutomobilitySounds.COLLISION.require(), SoundSource.AMBIENT, 0.22f, 0.7f + 0.06f * (this.level().random.nextFloat() - 0.5f), false);
            this.engineSpeed *= 0.6f;
            this.hadVehicleCollision = 12;
        }
    }

    public Vec3 getMeasuredMovement() {
        return this.position().subtract(this.lastMeasuredPos);
    }

    public void postMovementTick() {
        double addVelLen;
        float addedVelReduction = 0.1f;
        if (this.burningOut()) {
            addedVelReduction = 0.05f;
        }
        if ((addVelLen = this.addedVelocity.length()) > 0.0) {
            this.addedVelocity = this.addedVelocity.scale(Math.max(0.0, addVelLen - (double)addedVelReduction) / addVelLen);
        }
        float angle = (float)Math.toRadians(-this.speedDirection);
        if (this.touchingWall && (double)this.hSpeed > 0.1 && this.addedVelocity.length() <= 0.0) {
            this.updateEngineSpeed(this.engineSpeed / 3.6f);
            double knockSpeed = -0.2 * (double)this.hSpeed - 0.5;
            this.addedVelocity = this.addedVelocity.add(Math.sin(angle) * knockSpeed, 0.0, Math.cos(angle) * knockSpeed);
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), AutomobilitySounds.COLLISION.require(), SoundSource.AMBIENT, 0.76f, 0.65f + 0.06f * (this.level().random.nextFloat() - 0.5f), true);
            if (this.isVehicle() && this.level().isClientSide() && this.getPassengers().stream().anyMatch(p -> p instanceof LocalPlayer)) {
                this.controllerAction(c -> c.crashRumble());
            }
        }
        this.touchingWall = false;
        double yDisp = this.getMeasuredMovement().y();
        this.fallTicks = !this.automobileOnGround && yDisp < 0.0 ? ++this.fallTicks : 0;
        double highestPrevYDisp = 0.0;
        for (double d : this.prevYDisplacements) {
            highestPrevYDisp = Math.max(d, highestPrevYDisp);
        }
        if (this.wasOnGround && !this.automobileOnGround && !this.isFloorDirectlyBelow) {
            this.vSpeed = (float)Mth.clamp((double)highestPrevYDisp, (double)0.0, (double)(this.hSpeed * 0.6f));
        }
        this.vSpeed = Math.max(this.vSpeed - 0.08f, !this.automobileOnGround ? -1.2f : -0.01f);
        this.prevYDisplacements.push(yDisp);
        if (this.prevYDisplacements.size() > 2) {
            this.prevYDisplacements.removeLast();
        }
        float newAngularSpeed = this.angularSpeed;
        if (this.burningOut()) {
            float speed = (float)this.addedVelocity.length();
            float acc = 1.7f / (1.0f + this.getFrame().weight()) + 4.0f * speed;
            float lim = 9.0f + 4.0f * speed;
            newAngularSpeed = this.steering != 0.0f ? Mth.clamp((float)(newAngularSpeed + acc * this.steering), (float)(-lim), (float)lim) : AUtils.shift(newAngularSpeed, acc * 0.5f, 0.0f);
        } else if (this.hSpeed != 0.0f) {
            float traction = 1.0f / (1.0f + 4.0f * this.hSpeed) + 0.3f * this.stats.getGrip();
            newAngularSpeed = AUtils.shift(newAngularSpeed, 6.0f * traction, (this.drifting ? ((this.steering + (float)this.driftDir) * (float)this.driftDir * 2.5f + 1.5f) * (float)this.driftDir * ((1.0f - this.stats.getGrip() + 2.0f) / 2.5f) : this.steering * (4.0f * Math.min(this.hSpeed, 1.0f) + (this.hSpeed > 0.0f ? 2.0f : -3.5f))) * ((this.stats.getHandling() + 1.0f) / 2.0f));
        } else {
            newAngularSpeed = AUtils.shift(newAngularSpeed, 3.0f, 0.0f);
        }
        this.angularSpeed = newAngularSpeed * this.grip + this.angularSpeed * (1.0f - this.grip);
        if ((double)Math.abs(this.angularSpeed) < 3.0E-5) {
            this.angularSpeed = 0.0f;
        }
        float yawInc = this.angularSpeed;
        if (this.hSpeed == 0.0f && !this.burningOut()) {
            yawInc = 0.0f;
        }
        if (this.isControlledByLocalInstance()) {
            this.setYRot(this.getYRot() + yawInc);
            Entity first = this.getFirstPassenger();
            if (first != null && this.isDriving(first)) {
                if (AutomobileEntity.inLockedViewMode()) {
                    this.whenRotatedSmooth(first);
                } else {
                    this.whenRotated(yawInc, first);
                }
            }
        }
    }

    public void whenRotated(float dYaw, Entity e) {
        e.setYRot(Mth.wrapDegrees((float)(e.getYRot() + dYaw)));
        e.setYBodyRot(Mth.wrapDegrees((float)(e.getYRot() + dYaw)));
    }

    private void whenRotatedSmooth(Entity passenger) {
        double lockStrength = 0.36;
        if (this.drifting) {
            lockStrength = 0.16;
        } else if (this.burningOut()) {
            lockStrength = 0.43;
        }
        Vec3 selfDir = new Vec3(0.0, 0.0, 1.0).yRot((float)Math.toRadians(180.0f - this.getYRot()));
        Vec3 playerDir = new Vec3(0.0, 0.0, 1.0).yRot((float)Math.toRadians(180.0f - passenger.getYRot()));
        Vec3 newDir = playerDir.add(selfDir.scale(lockStrength));
        float rot = 180.0f - (float)Math.toDegrees(Math.atan2(newDir.x, newDir.z));
        passenger.setYRot(rot);
        passenger.setYBodyRot(rot);
    }

    public void move(MoverType movementType, Vec3 movement) {
        if (movementType == MoverType.PLAYER) {
            this.setPos(this.position().add(movement));
            return;
        }
        super.move(movementType, movement);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean isOneOfMyHitboxes(Entity e) {
        HitboxEntity hitbox;
        return e instanceof HitboxEntity && (hitbox = (HitboxEntity)e).automobile() == this;
    }

    public void accumulateCollisionAreas(Collection<CollisionArea> areas) {
        this.level().getEntitiesOfClass(Entity.class, this.getBoundingBox().inflate(3.0, 3.0, 3.0), e -> e != this && e.getVehicle() != this && !(e instanceof AutomobileEntity) && !this.isOneOfMyHitboxes((Entity)e)).forEach(e -> areas.add(CollisionArea.entity(e)));
    }

    public void displacementTick(boolean tick) {
        if (this.level().isClientSide()) {
            this.displacement.preTick();
            if (tick) {
                this.displacement.otherColliders.clear();
                this.accumulateCollisionAreas(this.displacement.otherColliders);
                this.displacement.tick(this.level(), this, this.position(), this.getYRot(), this.maxUpStep());
            }
            if (this.level().getBlockState(this.blockPosition()).getBlock() instanceof AutomobileAssemblerBlock) {
                this.displacement.lastVertical = this.displacement.verticalTarget = this.getY() - (double)(this.getWheels().model().radius() / 16.0f);
            }
            this.displacement.postTick();
        } else {
            this.displacement.currVertical = this.displacement.verticalTarget = this.getY();
            this.displacement.lastVertical = this.displacement.verticalTarget;
        }
    }

    public Displacement getDisplacement() {
        return this.displacement;
    }

    public void collisionStateTick() {
        this.wasOnGround = this.automobileOnGround;
        this.automobileOnGround = false;
        this.isFloorDirectlyBelow = false;
        AABB b = this.getBoundingBox();
        AABB groundBox = new AABB(b.minX, b.minY - 0.04, b.minZ, b.maxX, b.minY, b.maxZ);
        double wid = (b.getXsize() + b.getZsize()) * 0.5;
        AABB floorBox = new AABB(b.minX + wid * 0.94, b.minY - 0.05, b.minZ + wid * 0.94, b.maxX - wid * 0.94, b.minY, b.maxZ - wid * 0.94);
        AABB wallBox = b.deflate(0.05).move(this.lastVelocity.normalize().scale(0.12));
        BlockPos start = new BlockPos((int)Math.floor(b.minX - 0.1), (int)Math.floor(b.minY - 0.2), (int)Math.floor(b.minZ - 0.1));
        BlockPos end = new BlockPos((int)Math.floor(b.maxX + 0.1), (int)Math.floor(b.maxY + 0.2 + (double)this.maxUpStep()), (int)Math.floor(b.maxZ + 0.1));
        VoxelShape groundCuboid = Shapes.create((AABB)groundBox);
        VoxelShape floorCuboid = Shapes.create((AABB)floorBox);
        VoxelShape wallCuboid = Shapes.create((AABB)wallBox);
        VoxelShape stepWallCuboid = wallCuboid.move(0.0, (double)this.maxUpStep() - 0.05, 0.0);
        boolean wallHit = false;
        boolean stepWallHit = false;
        CollisionContext shapeCtx = CollisionContext.of((Entity)this);
        if (this.level().hasChunksAt(start, end)) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = start.getX(); x <= end.getX(); ++x) {
                for (int y = start.getY(); y <= end.getY(); ++y) {
                    for (int z = start.getZ(); z <= end.getZ(); ++z) {
                        pos.set(x, y, z);
                        BlockState state = this.level().getBlockState((BlockPos)pos);
                        VoxelShape blockShape = state.getCollisionShape((BlockGetter)this.level(), (BlockPos)pos, shapeCtx).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                        this.automobileOnGround |= Shapes.joinIsNotEmpty((VoxelShape)blockShape, (VoxelShape)groundCuboid, (BooleanOp)BooleanOp.AND);
                        this.isFloorDirectlyBelow |= Shapes.joinIsNotEmpty((VoxelShape)blockShape, (VoxelShape)floorCuboid, (BooleanOp)BooleanOp.AND);
                        wallHit |= Shapes.joinIsNotEmpty((VoxelShape)blockShape, (VoxelShape)wallCuboid, (BooleanOp)BooleanOp.AND);
                        stepWallHit |= Shapes.joinIsNotEmpty((VoxelShape)blockShape, (VoxelShape)stepWallCuboid, (BooleanOp)BooleanOp.AND);
                    }
                }
            }
        }
        this.touchingWall = wallHit && stepWallHit;
        HashSet<CollisionArea> otherColliders = new HashSet<CollisionArea>();
        this.accumulateCollisionAreas(otherColliders);
        this.automobileOnGround |= otherColliders.stream().anyMatch(col -> col.boxIntersects(groundBox));
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.trackedX = x;
        this.trackedY = y;
        this.trackedZ = z;
        this.trackedYaw = yaw;
        this.lerpTicks = this.getType().updateInterval() + 1;
    }

    private float calculateAcceleration(float speed, AutomobileStats stats) {
        return 1.0f / (300.0f * speed + (18.5f - stats.getAcceleration() * 5.3f)) * (0.9f * ((stats.getAcceleration() + 1.0f) / 2.0f));
    }

    public float getHandling() {
        return this.stats.getHandling();
    }

    public void provideClientInput(boolean fwd, boolean back, boolean left, boolean right, boolean space, boolean ctrl) {
        if (this.input.setDigitalInputs(fwd, back, left, right, space, ctrl)) {
            ClientPackets.sendServerboundAutomobileSyncPacket(this);
        }
    }

    public void boost(float power, int time) {
        if (power > this.boostPower || time > this.boostTimer) {
            this.boostTimer = time;
            this.boostPower = power;
        }
        if (this.isControlledByLocalInstance()) {
            this.updateEngineSpeed(Math.max(this.engineSpeed, this.stats.getComfortableSpeed() * 0.5f));
        }
        this.controllerAction(c -> c.updateBoostingRumbleState(true, power));
    }

    private void steeringTick() {
        this.lastSteering = this.steering;
        this.steering = AUtils.shift(this.steering, 0.42f, this.input.steering);
    }

    private void consumeTurboCharge() {
        if (this.turboCharge > 115) {
            this.boost(0.38f, 38);
        } else if (this.turboCharge > 70) {
            this.boost(0.3f, 21);
        } else if (this.turboCharge > 35) {
            this.boost(0.23f, 9);
        }
        this.turboCharge = 0;
    }

    private void driftingTick() {
        int prevTurboCharge = this.turboCharge;
        if (!this.prevHoldDrift && this.input.holdingDrift) {
            RearAttachment rearAttachment;
            if (this.steering != 0.0f && !this.drifting && this.hSpeed > 0.4f && this.automobileOnGround) {
                this.setDrifting(true);
                this.controllerAction(AutomobileController::driftChargeRumble);
                this.driftDir = this.steering > 0.0f ? 1 : -1;
                this.updateEngineSpeed(this.engineSpeed - 0.028f * this.engineSpeed);
            } else if (this.steering == 0.0f && !this.level().isClientSide() && (rearAttachment = this.getRearAttachment()) instanceof DeployableRearAttachment) {
                DeployableRearAttachment att = (DeployableRearAttachment)rearAttachment;
                att.deploy();
            }
        }
        if (this.drifting) {
            if (this.automobileOnGround()) {
                this.createDriftParticles();
            }
            if (this.prevHoldDrift && !this.input.holdingDrift) {
                this.setDrifting(false);
                this.controllerAction(c -> c.updateMaxChargeRumbleState(false));
                this.consumeTurboCharge();
            } else if (this.hSpeed < 0.33f) {
                this.setDrifting(false);
                this.controllerAction(c -> c.updateMaxChargeRumbleState(false));
                this.turboCharge = 0;
            }
            if (this.automobileOnGround) {
                this.turboCharge += this.input.steering * (float)this.driftDir > 0.0f ? 2 : 1;
            }
        }
        if (this.turboCharge == 35 || this.turboCharge == 70 || this.turboCharge == 115) {
            this.controllerAction(AutomobileController::driftChargeRumble);
        }
        if (this.turboCharge >= 115 && prevTurboCharge < 115) {
            this.controllerAction(c -> c.updateMaxChargeRumbleState(true));
        } else if (prevTurboCharge >= 115 && this.turboCharge < 115) {
            this.controllerAction(c -> c.updateMaxChargeRumbleState(false));
        }
        this.prevHoldDrift = this.input.holdingDrift;
    }

    private void endBurnout() {
        this.setBurningOut(false);
        this.updateEngineSpeed(0.0f);
    }

    private void burnoutTick() {
        if (this.burningOut()) {
            if (this.automobileOnGround()) {
                if (this.addedVelocity.length() > 0.05 || (double)Math.abs(this.angularSpeed) > 0.05) {
                    this.createDriftParticles();
                }
                if ((double)this.hSpeed < 0.08 && this.turboCharge <= 35) {
                    ++this.turboCharge;
                }
            }
            if (!this.input.braking) {
                this.endBurnout();
                this.consumeTurboCharge();
            } else if (!this.input.accelerating) {
                this.endBurnout();
                this.turboCharge = 0;
            }
            this.wheelAngle += 20.0f;
        } else if ((this.input.accelerating || (double)this.hSpeed > 0.05) && this.input.braking) {
            this.setBurningOut(true);
            this.turboCharge = 0;
        }
    }

    public void createDriftParticles() {
        for (WheelBase.WheelPos wheel : this.getFrame().model().wheelBase().wheels()) {
            if (wheel.end() != WheelBase.WheelEnd.BACK) continue;
            Vector3d pos = new Vector3d((double)(wheel.right() + (float)(wheel.right() > 0.0f ? 1 : -1) * this.getWheels().model().width() * wheel.scale()), 0.0, (double)wheel.forward()).mul(0.0625);
            this.localPosToWorldSpace(pos);
            pos.add(0.0, 0.4, 0.0);
            this.level().addParticle((ParticleOptions)AutomobilityParticles.DRIFT_SMOKE.require(), pos.x(), pos.y(), pos.z(), 0.0, 0.0, 0.0);
        }
    }

    private static boolean inLockedViewMode() {
        return Platform.get().controller().inControllerMode();
    }

    @Override
    public float getAutomobileYaw(float tickDelta) {
        return this.getViewYRot(tickDelta);
    }

    @Override
    public float getRearAttachmentYaw(float tickDelta) {
        return this.rearAttachment.yaw(tickDelta);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity firstPassenger = this.getFirstPassenger();
        boolean canDrive = true;
        FrontAttachment fAtt = this.getFrontAttachment();
        if (fAtt != null) {
            canDrive = fAtt.canDrive(firstPassenger);
        }
        if (firstPassenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)firstPassenger;
            if (canDrive) {
                return living;
            }
        }
        return null;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.hasSpaceForPassengers();
    }

    /*
     * Unable to fully structure code
     */
    protected void addPassenger(Entity passenger) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (passenger.getVehicle() == this) break block2;
                        super.addPassenger(passenger);
                        break block3;
                    }
                    if (!this.passengers.isEmpty()) break block4;
                    this.passengers = ImmutableList.of((Object)passenger);
                    break block5;
                }
                newPassengerList = Lists.newArrayList((Iterable)this.passengers);
                if (this.level().isClientSide() || !(passenger instanceof Player)) ** GOTO lbl-1000
                player = (Player)passenger;
                if (this.canKickPassengerOut(this.getFirstPassenger(), player)) {
                    newPassengerList.addFirst(passenger);
                } else lbl-1000:
                // 2 sources

                {
                    newPassengerList.add(passenger);
                }
                this.passengers = ImmutableList.copyOf((Collection)newPassengerList);
            }
            this.gameEvent((Holder)GameEvent.ENTITY_MOUNT, passenger);
        }
    }

    @Override
    public boolean hasInventory() {
        return this.getRearAttachment().hasMenu();
    }

    @Override
    public void openInventory(Player player) {
        MenuProvider factory = this.getRearAttachment().createMenu(new AutomobileContainerLevelAccess(this));
        if (factory != null) {
            player.openMenu(factory);
        }
    }

    public float getStandStillTime() {
        return this.standStillTime;
    }

    public void playHitSound(Vec3 pos) {
        this.level().gameEvent((Entity)this, (Holder)GameEvent.ENTITY_DAMAGE, pos);
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.COPPER_BREAK, SoundSource.AMBIENT, 1.0f, 0.9f + this.level().random.nextFloat() * 0.2f);
    }

    private void dropParts(Vec3 pos) {
        ((Holder)this.entityData.get(FRAME_TYPE)).unwrapKey().ifPresent(key -> this.level().addFreshEntity((Entity)new ItemEntity(this.level(), pos.x, pos.y, pos.z, AutomobilityItems.AUTOMOBILE_FRAME.require().createStack(key))));
        ((Holder)this.entityData.get(ENGINE_TYPE)).unwrapKey().ifPresent(key -> this.level().addFreshEntity((Entity)new ItemEntity(this.level(), pos.x, pos.y, pos.z, AutomobilityItems.AUTOMOBILE_ENGINE.require().createStack(key))));
        ((Holder)this.entityData.get(WHEEL_TYPE)).unwrapKey().ifPresent(key -> {
            ItemStack wheelStack = AutomobilityItems.AUTOMOBILE_WHEEL.require().createStack(key);
            wheelStack.setCount(this.getFrame().model().wheelBase().wheelCount());
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), pos.x, pos.y, pos.z, wheelStack));
        });
    }

    public void destroyRearAttachment(boolean drop) {
        if (drop) {
            Vec3 dropPos = this.rearAttachment.pos();
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), dropPos.x, dropPos.y, dropPos.z, AutomobilityItems.REAR_ATTACHMENT.require().createStack(this.getRearAttachmentType())));
        }
        this.setRearAttachment(RearAttachmentType.EMPTY);
    }

    public void destroyFrontAttachment(boolean drop) {
        if (drop) {
            Vec3 dropPos = this.frontAttachment.pos();
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), dropPos.x, dropPos.y, dropPos.z, AutomobilityItems.FRONT_ATTACHMENT.require().createStack(this.getFrontAttachmentType())));
        }
        this.setFrontAttachment(FrontAttachmentType.EMPTY);
    }

    public void destroyAutomobile(boolean drop, Entity.RemovalReason reason) {
        if (!((RearAttachmentType)this.rearAttachment.type).isEmpty()) {
            this.destroyRearAttachment(drop);
        }
        if (!((FrontAttachmentType)this.frontAttachment.type).isEmpty()) {
            this.destroyFrontAttachment(drop);
        }
        if (drop) {
            this.dropParts(this.position().add(0.0, 0.3, 0.0));
        }
        this.remove(reason);
    }

    public boolean canKickPassengerOut(@Nullable Entity passenger, Player kickerOuter) {
        if (passenger != null) {
            if (passenger instanceof Player) {
                return false;
            }
            if (passenger.isInvulnerable()) {
                return !this.canAddPassenger((Entity)kickerOuter) && kickerOuter.isCreative();
            }
        }
        return true;
    }

    public InteractionResult handleInteraction(Player player, InteractionHand hand) {
        Item item;
        boolean vulnerable;
        if (player.isShiftKeyDown() && this.hasInventory()) {
            if (!this.level().isClientSide()) {
                this.openInventory(player);
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        boolean bl = vulnerable = !this.isInvulnerable() || player.isCreative();
        if (vulnerable && stack.is(AutomobilityItems.CROWBAR.require())) {
            double playerAngle = Math.toDegrees(Math.atan2(player.getZ() - this.getZ(), player.getX() - this.getX()));
            double angleDiff = Mth.wrapDegrees((double)((double)this.getYRot() - playerAngle));
            if (angleDiff < 0.0 && !((FrontAttachmentType)this.frontAttachment.type).isEmpty()) {
                this.destroyFrontAttachment(!player.isCreative());
                this.playHitSound(this.getHeadPos());
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!((RearAttachmentType)this.rearAttachment.type).isEmpty()) {
                this.destroyRearAttachment(!player.isCreative());
                this.playHitSound(this.rearAttachment.pos());
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            this.destroyAutomobile(!player.isCreative(), Entity.RemovalReason.KILLED);
            this.playHitSound(this.position());
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (vulnerable && (item = stack.getItem()) instanceof AutomobileInteractable) {
            AutomobileInteractable interactable = (AutomobileInteractable)item;
            return interactable.interactAutomobile(stack, player, hand, this);
        }
        if (!this.decorative) {
            if (!this.hasSpaceForPassengers()) {
                if (this.canKickPassengerOut(this.getFirstPassenger(), player)) {
                    if (!this.level().isClientSide()) {
                        this.getFirstPassenger().stopRiding();
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                return InteractionResult.PASS;
            }
            if (!this.level().isClientSide()) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return InteractionResult.PASS;
    }

    public Vec3 fixPassengerRidingOffset(Vec3 offset) {
        return offset.add(0.0, (double)this.getWheels().model().radius(), 0.0).scale(0.0625);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        if (this.getFrame() == null) {
            super.positionRider(passenger, moveFunc);
        }
        Vec3 attPoint = passenger.getVehicleAttachmentPoint((Entity)this);
        double attYOffset = (double)passenger.getEyeHeight() - attPoint.y();
        AutomobileFrame.FrameModel frameModel = this.getFrame().model();
        if (this.hasPassenger(passenger)) {
            int idx = this.getPassengers().indexOf(passenger);
            Vec3 offset = Vec3.ZERO;
            offset = idx == 0 ? this.fixPassengerRidingOffset(frameModel.driverSeatPos()) : (idx <= frameModel.passengerSeats().size() ? this.fixPassengerRidingOffset(frameModel.passengerSeats().get(idx - 1)) : new Vec3(0.0, 0.0, (double)(-this.getFrame().model().rearAttachmentPos() / 16.0f)).add(this.rearAttachment.scaledYawVec().yRot((float)Math.toRadians(this.getYRot()))).add(0.0, this.rearAttachment.getPassengerHeightOffset(), 0.0));
            Vector3d pos = new Vector3d(offset.x(), offset.y() + attYOffset, offset.z());
            this.localPosToWorldSpace(pos);
            pos.sub(attPoint.x(), attPoint.y() + attYOffset, attPoint.z());
            moveFunc.accept(passenger, pos.x(), pos.y(), pos.z());
            if (this.getControllingPassenger() != passenger) {
                this.whenRotated(this.getYRot() - this.prevYawForRotate, passenger);
            }
        }
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        float maxWidth = this.getBbWidth();
        float maxHeight = this.getBbHeight();
        for (AutomobileFrame.Hitbox box : this.getFrame().hitboxes()) {
            float height;
            Vec3 origin = box.origin();
            if (Math.abs(origin.z()) > (double)(0.5f * box.width())) continue;
            float width = ((float)Math.abs(origin.x()) + 0.5f * box.width()) * 2.0f;
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (!((height = (float)(origin.y() + (double)box.height() * 0.5)) > maxHeight)) continue;
            maxHeight = height;
        }
        float yaw = this.getYRot() + (float)(passenger.getMainArm() == HumanoidArm.RIGHT ? 90 : -90);
        Vec3 dir = Entity.getCollisionHorizontalEscapeVector((double)((double)maxWidth + 0.25), (double)passenger.getBbWidth(), (float)yaw);
        Vector3d scanPos = new Vector3d(dir.x() + this.getX(), dir.y() + this.displacement.getVertical(1.0f), dir.z() + this.getZ());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double maxDismountHeight = this.getBoundingBox().maxY + 0.75;
        block1: for (Pose pose : passenger.getDismountPoses()) {
            pos.set(scanPos.x(), scanPos.y(), scanPos.z());
            do {
                double height = this.level().getBlockFloorHeight((BlockPos)pos);
                if ((double)pos.getY() + height > maxDismountHeight) continue block1;
                if (DismountHelper.isBlockFloorValid((double)height)) {
                    AABB bounds = passenger.getLocalBoundsForPose(pose);
                    Vec3 dismountPos = new Vec3(scanPos.x(), (double)pos.getY() + height, scanPos.z());
                    if (DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)bounds.move(dismountPos))) {
                        passenger.setPose(pose);
                        return dismountPos;
                    }
                }
                pos.move(Direction.UP);
            } while (!((double)pos.getY() > maxDismountHeight));
        }
        return new Vec3(this.getX(), this.getY() + (double)maxHeight, this.getZ());
    }

    public boolean canCollideWith(Entity entity) {
        HitboxEntity hitbox;
        return entity instanceof HitboxEntity && (hitbox = (HitboxEntity)entity).automobile() != this;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(REAR_ATTACHMENT_YAW, (Object)Float.valueOf(0.0f));
        builder.define(REAR_ATTACHMENT_ANIMATION, (Object)Float.valueOf(0.0f));
        builder.define(FRONT_ATTACHMENT_ANIMATION, (Object)Float.valueOf(0.0f));
        builder.define(FRAME_TYPE, (Object)Holder.direct((Object)AutomobileFrame.EMPTY));
        builder.define(WHEEL_TYPE, (Object)Holder.direct((Object)AutomobileWheel.EMPTY));
        builder.define(ENGINE_TYPE, (Object)Holder.direct((Object)AutomobileEngine.EMPTY));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (REAR_ATTACHMENT_YAW.equals(data)) {
            this.rearAttachment.onTrackedYawUpdated(this.getTrackedRearAttachmentYaw());
        } else if (REAR_ATTACHMENT_ANIMATION.equals(data)) {
            this.rearAttachment.onTrackedAnimationUpdated(this.getTrackedRearAttachmentAnimation());
        } else if (FRONT_ATTACHMENT_ANIMATION.equals(data)) {
            this.frontAttachment.onTrackedAnimationUpdated(this.getTrackedFrontAttachmentAnimation());
        } else if (FRAME_TYPE.equals(data)) {
            this.displacement.applyWheelbase(this.getFrame().model().wheelBase());
            this.size = this.getFrame().makeBounds();
            this.refreshDimensions();
        }
        if (FRAME_TYPE.equals(data) || WHEEL_TYPE.equals(data) || ENGINE_TYPE.equals(data)) {
            this.stats.from(this.getFrame(), this.getWheels(), this.getEngine());
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    public void setTrackedRearAttachmentYaw(float value) {
        this.entityData.set(REAR_ATTACHMENT_YAW, (Object)Float.valueOf(value));
    }

    public float getTrackedRearAttachmentYaw() {
        return ((Float)this.entityData.get(REAR_ATTACHMENT_YAW)).floatValue();
    }

    public void setTrackedRearAttachmentAnimation(float animation) {
        this.entityData.set(REAR_ATTACHMENT_ANIMATION, (Object)Float.valueOf(animation));
    }

    public float getTrackedRearAttachmentAnimation() {
        return ((Float)this.entityData.get(REAR_ATTACHMENT_ANIMATION)).floatValue();
    }

    public void setTrackedFrontAttachmentAnimation(float animation) {
        this.entityData.set(FRONT_ATTACHMENT_ANIMATION, (Object)Float.valueOf(animation));
    }

    public float getTrackedFrontAttachmentAnimation() {
        return ((Float)this.entityData.get(FRONT_ATTACHMENT_ANIMATION)).floatValue();
    }

    public void bounce() {
        this.suspensionBounceTimer = 3;
        this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), AutomobilitySounds.LANDING.require(), SoundSource.AMBIENT, 1.0f, 1.5f + 0.15f * (this.level().random.nextFloat() - 0.5f), true);
        this.controllerAction(AutomobileController::groundThudRumble);
    }

    public Vec3 collide(Vec3 mvmt) {
        boolean movedIntoGround;
        AABB myCollider = this.getBoundingBox();
        List entityColliders = this.level().getEntityCollisions((Entity)this, myCollider.expandTowards(mvmt));
        Vec3 mvmtHit = mvmt.lengthSqr() == 0.0 ? mvmt : AutomobileEntity.collideBoundingBox((Entity)this, (Vec3)mvmt, (AABB)myCollider, (Level)this.level(), (List)entityColliders);
        boolean bl = movedIntoGround = mvmt.y != mvmtHit.y && mvmt.y < 0.0;
        if (this.maxUpStep() > 0.0f && (movedIntoGround || this.onGround()) && (mvmt.x != mvmtHit.x || mvmt.z != mvmtHit.z)) {
            Vec3 mvmtHorizThenUp;
            double upStep = this.maxUpStep();
            Vec3 mvmtUpHit = AutomobileEntity.moveAndCollide(this, new Vec3(mvmt.x, upStep, mvmt.z), myCollider, this.level(), entityColliders);
            Vec3 mvmtHorizHit = AutomobileEntity.moveAndCollide(this, new Vec3(0.0, upStep, 0.0), myCollider.expandTowards(mvmt.x, 0.0, mvmt.z), this.level(), entityColliders);
            if (mvmtHorizHit.y < upStep && (mvmtHorizThenUp = AutomobileEntity.moveAndCollide(this, new Vec3(mvmt.x, 0.0, mvmt.z), myCollider.move(mvmtHorizHit), this.level(), entityColliders).add(mvmtHorizHit)).horizontalDistanceSqr() > mvmtUpHit.horizontalDistanceSqr()) {
                mvmtUpHit = mvmtHorizThenUp;
            }
            if (mvmtUpHit.horizontalDistanceSqr() > mvmtHit.horizontalDistanceSqr()) {
                return mvmtUpHit.add(AutomobileEntity.moveAndCollide(this, new Vec3(0.0, mvmt.y - mvmtUpHit.y, 0.0), myCollider.move(mvmtUpHit), this.level(), entityColliders));
            }
        }
        return mvmtHit;
    }

    public static Vec3 moveAndCollide(Entity entity, Vec3 mvmt, AABB myCollider, Level level, List<VoxelShape> nearbyEntities) {
        List colliders = AutomobileEntity.collectColliders((Entity)entity, (Level)level, nearbyEntities, (AABB)myCollider.expandTowards(mvmt));
        return AutomobileEntity.collideWithShapes((Vec3)mvmt, (AABB)myCollider, (List)colliders);
    }

    public void localPosToWorldSpace(Vector3d position) {
        position.rotateY(Math.toRadians(-this.getYRot()));
        Displacement disp = this.getDisplacement();
        Quaternionf rot = new Quaternionf();
        disp.getAngular(1.0f, rot);
        position.rotate((Quaterniondc)new Quaterniond((double)rot.x(), (double)rot.y(), (double)rot.z(), (double)rot.w()));
        Vec3 pos = this.position();
        position.add(pos.x(), pos.y() + (double)disp.getVerticalOffset(1.0f, this), pos.z());
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.size;
    }

    @Override
    public Container underlyingContainer() {
        RearAttachment rearAttachment = this.getRearAttachment();
        if (rearAttachment instanceof Container) {
            Container container = (Container)rearAttachment;
            return container;
        }
        return null;
    }

    public static class Input {
        public boolean accelerating;
        public boolean braking;
        public boolean holdingDrift;
        public boolean holdingHorn;
        public float steering;

        public boolean setDigitalInputs(boolean fwd, boolean back, boolean left, boolean right, boolean space, boolean ctrl) {
            boolean isLeft = this.steering < 0.0f;
            boolean isRight = this.steering > 0.0f;
            boolean changed = fwd != this.accelerating || back != this.braking || left != isLeft || right != isRight || space != this.holdingDrift || ctrl != this.holdingHorn;
            this.accelerating = fwd;
            this.braking = back;
            this.steering = (left ? -1 : 0) + (right ? 1 : 0);
            this.holdingDrift = space;
            this.holdingHorn = ctrl;
            return changed;
        }

        public boolean setInputs(boolean fwd, boolean back, float side, boolean space, boolean ctrl) {
            boolean changed = fwd != this.accelerating || back != this.braking || this.steering != side || space != this.holdingDrift || ctrl != this.holdingHorn;
            this.accelerating = fwd;
            this.braking = back;
            this.steering = side;
            this.holdingDrift = space;
            this.holdingHorn = ctrl;
            return changed;
        }

        public void clearInputs() {
            this.accelerating = false;
            this.braking = false;
            this.steering = 0.0f;
            this.holdingDrift = false;
            this.holdingHorn = false;
        }

        public void writePacket(FriendlyByteBuf buf) {
            buf.writeBoolean(this.accelerating);
            buf.writeBoolean(this.braking);
            buf.writeFloat(this.steering);
            buf.writeBoolean(this.holdingDrift);
            buf.writeBoolean(this.holdingHorn);
        }

        public void readPacket(FriendlyByteBuf buf) {
            this.accelerating = buf.readBoolean();
            this.braking = buf.readBoolean();
            this.steering = buf.readFloat();
            this.holdingDrift = buf.readBoolean();
            this.holdingHorn = buf.readBoolean();
        }
    }

    public static final class Displacement {
        private static final int SCAN_STEPS_PER_BLOCK = 20;
        private static final double INV_SCAN_STEPS = 0.05;
        private boolean wereAllOnGround = true;
        private double lastVertical = 0.0;
        private double currVertical = 0.0;
        private double verticalTarget = 0.0;
        private final Quaternionf lastAngular = new Quaternionf();
        private final Quaternionf currAngular = new Quaternionf();
        private final Quaternionf angularTarget = new Quaternionf();
        private final List<Vec3> scanPoints = new ArrayList<Vec3>();
        public final Set<CollisionArea> otherColliders = new HashSet<CollisionArea>();

        public void preTick() {
            this.lastVertical = this.currVertical;
            this.lastAngular.set((Quaternionfc)this.currAngular);
        }

        public void postTick() {
            float lerpAmount = 1.0f;
            Quaternionf rotation = this.angularTarget.mul((Quaternionfc)this.currAngular.invert(new Quaternionf()), new Quaternionf());
            AxisAngle4f rotationInfo = new AxisAngle4f((Quaternionfc)rotation);
            if (rotationInfo.angle > 0.0f) {
                lerpAmount = (float)Math.min((double)rotationInfo.angle, Math.toRadians(7.0)) / rotationInfo.angle;
                lerpAmount = Mth.clamp((float)lerpAmount, (float)0.0f, (float)1.0f);
                this.currAngular.slerp((Quaternionfc)this.angularTarget, lerpAmount);
            }
            this.currVertical = Mth.lerp((double)Mth.sqrt((float)lerpAmount), (double)this.currVertical, (double)this.verticalTarget);
        }

        public void tick(Level world, AutomobileEntity entity, Vec3 centerPos, double yaw, double stepHeight) {
            yaw = 360.0 - yaw;
            Vec3 lowestDisplacementPos = null;
            Vec3 highestDisplacementPos = null;
            ArrayList<Vec3> scannedPoints = new ArrayList<Vec3>();
            HashSet<CollisionArea> colliders = new HashSet<CollisionArea>();
            boolean anyOnGround = false;
            boolean allOnGround = true;
            for (Vec3 scanPoint : this.scanPoints) {
                scanPoint = scanPoint.yRot((float)Math.toRadians(yaw));
                Vec3 pointPos = scanPoint.add(centerPos);
                colliders.clear();
                colliders.addAll(this.otherColliders);
                double scanDist = scanPoint.length();
                int heightOffset = (int)Math.ceil(scanDist);
                Cursor3D iter = new Cursor3D((int)Math.min(Math.floor(centerPos.x), Math.floor(pointPos.x)), (int)Math.floor(centerPos.y) - heightOffset, (int)Math.min(Math.floor(centerPos.z), Math.floor(pointPos.z)), (int)Math.max(Math.floor(centerPos.x), Math.floor(pointPos.x)), (int)Math.floor(centerPos.y) + heightOffset, (int)Math.max(Math.floor(centerPos.z), Math.floor(pointPos.z)));
                BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
                while (iter.advance()) {
                    mpos.set(iter.nextX(), iter.nextY(), iter.nextZ());
                    BlockState state = world.getBlockState((BlockPos)mpos);
                    Block block = state.getBlock();
                    if (block instanceof SpecialAutomobileColliderBlock) {
                        SpecialAutomobileColliderBlock special = (SpecialAutomobileColliderBlock)block;
                        colliders.add(special.getCollisionArea(state, world, (BlockPos)mpos, 0.1));
                        continue;
                    }
                    VoxelShape shape = state.getCollisionShape((BlockGetter)world, (BlockPos)mpos);
                    if (shape.isEmpty()) continue;
                    if (shape == Shapes.block()) {
                        colliders.add(CollisionArea.box(mpos.getX(), (double)mpos.getY() - 0.1, mpos.getZ(), mpos.getX() + 1, mpos.getY() + 1, mpos.getZ() + 1));
                        continue;
                    }
                    shape.move((double)mpos.getX(), (double)mpos.getY(), (double)mpos.getZ()).forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> colliders.add(CollisionArea.box(minX, minY - 0.1, minZ, maxX, maxY, maxZ)));
                }
                Vec3 pointDir = new Vec3(scanPoint.x, 0.0, scanPoint.z).normalize().scale(0.05);
                double pointY = centerPos.y;
                int i = 0;
                while ((double)i < Math.ceil(scanDist * 20.0)) {
                    double pointX = centerPos.x + (double)i * pointDir.x;
                    double pointZ = centerPos.z + (double)i * pointDir.z;
                    double originalPointY = pointY;
                    boolean ground = false;
                    double nextPointY = pointY -= 0.07500000000000001;
                    for (int j = 0; j < 2; ++j) {
                        for (CollisionArea col : colliders) {
                            if (!col.isPointInside(pointX, nextPointY, pointZ)) continue;
                            nextPointY = Math.max(nextPointY, col.highestY(pointX, nextPointY, pointZ));
                            pointY = originalPointY;
                        }
                    }
                    if (nextPointY - pointY < stepHeight + 0.07500000000000001) {
                        pointY = nextPointY;
                        ground = true;
                    }
                    if (ground) {
                        anyOnGround = true;
                    } else {
                        allOnGround = false;
                    }
                    ++i;
                }
                pointPos = new Vec3(pointPos.x, pointY, pointPos.z);
                if (lowestDisplacementPos == null || pointPos.y < lowestDisplacementPos.y) {
                    lowestDisplacementPos = pointPos;
                }
                if (highestDisplacementPos == null || pointPos.y > highestDisplacementPos.y) {
                    highestDisplacementPos = pointPos;
                }
                scannedPoints.add(pointPos);
            }
            if (allOnGround && !this.wereAllOnGround) {
                entity.bounce();
            }
            this.wereAllOnGround = allOnGround;
            this.verticalTarget = centerPos.y;
            if (!anyOnGround) {
                return;
            }
            this.angularTarget.identity();
            if (lowestDisplacementPos != null) {
                Vec3 displacementCenterPos = new Vec3(centerPos.x, (lowestDisplacementPos.y + highestDisplacementPos.y) * 0.5, centerPos.z);
                Vec3 combinedNormals = Vec3.ZERO;
                int normalCount = 0;
                Vec3 positiveXOffset = null;
                Vec3 negativeXOffset = null;
                Vec3 positiveZOffset = null;
                Vec3 negativeZOffset = null;
                for (Vec3 pointPos : scannedPoints) {
                    Vec3 normal;
                    Vec3 pointOffset = pointPos.subtract(displacementCenterPos);
                    if (pointOffset.x > 0.0) {
                        if (positiveXOffset != null) {
                            normal = positiveXOffset.cross(pointOffset).normalize();
                            if (normal.y < 0.0) {
                                normal = normal.reverse();
                            }
                            combinedNormals = combinedNormals.add(normal);
                            ++normalCount;
                            positiveXOffset = null;
                            continue;
                        }
                        positiveXOffset = pointOffset;
                        continue;
                    }
                    if (pointOffset.x < 0.0) {
                        if (negativeXOffset != null) {
                            normal = negativeXOffset.cross(pointOffset).normalize();
                            if (normal.y < 0.0) {
                                normal = normal.reverse();
                            }
                            combinedNormals = combinedNormals.add(normal);
                            ++normalCount;
                            negativeXOffset = null;
                            continue;
                        }
                        negativeXOffset = pointOffset;
                        continue;
                    }
                    if (pointOffset.z > 0.0) {
                        if (positiveZOffset != null) {
                            normal = positiveZOffset.cross(pointOffset).normalize();
                            if (normal.y < 0.0) {
                                normal = normal.reverse();
                            }
                            combinedNormals = combinedNormals.add(normal);
                            ++normalCount;
                            positiveZOffset = null;
                            continue;
                        }
                        positiveZOffset = pointOffset;
                        continue;
                    }
                    if (!(pointOffset.z < 0.0)) continue;
                    if (negativeZOffset != null) {
                        normal = negativeZOffset.cross(pointOffset).normalize();
                        if (normal.y < 0.0) {
                            normal = normal.reverse();
                        }
                        combinedNormals = combinedNormals.add(normal);
                        ++normalCount;
                        negativeZOffset = null;
                        continue;
                    }
                    negativeZOffset = pointOffset;
                }
                combinedNormals = normalCount > 0 ? combinedNormals.scale((double)(1.0f / (float)normalCount)) : new Vec3(0.0, 1.0, 0.0);
                Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
                Vector3f rotatedUp = new Vector3f((float)combinedNormals.x(), (float)combinedNormals.y(), (float)combinedNormals.z());
                up.rotationTo((Vector3fc)rotatedUp, this.angularTarget);
                this.verticalTarget = (float)displacementCenterPos.y;
            }
        }

        public void applyWheelbase(WheelBase wheelBase) {
            this.scanPoints.clear();
            for (WheelBase.WheelPos pos : wheelBase.wheels()) {
                if (pos.end() == WheelBase.WheelEnd.NONE) continue;
                this.scanPoints.add(new Vec3((double)(pos.right() / 16.0f), 0.0, (double)(pos.forward() / 16.0f)));
            }
        }

        public double getVertical(float tickDelta) {
            return Mth.lerp((double)tickDelta, (double)this.lastVertical, (double)this.currVertical);
        }

        public float getVerticalOffset(float tickDelta, AutomobileEntity entity) {
            return (float)(this.getVertical(tickDelta) - entity.getPosition(tickDelta).y());
        }

        public void getAngular(float tickDelta, Quaternionf rot) {
            this.lastAngular.slerp((Quaternionfc)this.currAngular, tickDelta, rot);
        }
    }

    public record IncomingCollision(Vec3 depth, Vec3 velocity, Vec3 origin, float inertia) {
    }
}

